/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.i18n;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;

@Singleton
public class I18nMessageHandler
implements Telegraph {
    private final MessageDispatcher messageDispatcher;
    private final I18nTranslator i18nTranslator;

    @Inject
    public I18nMessageHandler(MessageDispatcher messageDispatcher, I18nTranslator i18nTranslator) {
        this.messageDispatcher = messageDispatcher;
        this.i18nTranslator = i18nTranslator;
        messageDispatcher.addListener(this, 290);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 290: {
                for (GameMaterialType materialType : GameMaterialType.values()) {
                    materialType.setI18NValue(this.i18nTranslator.getTranslatedString(materialType.getI18nKey()));
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }
}

